﻿--DROP PROCEDURE App.NVCC_usp_ProductionAccessLogUniqueSta3n

CREATE PROCEDURE [App].[NVCC_usp_ProductionAccessLogUniqueSta3n]

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_ProductionAccessLogUniqueSta3n
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 05-27-2016
--
--Last Changed          : 2017-07-24
--Last Changed By		: Brian Diggs
--Reason For Change		: Convert to using NVCC_ProductionLog
--
--Purpose               : Get unique stations from the access log
--==================================================================================
--Uses: App.NVCC_ProductionLog
--Uses: App.udf_StationName
BEGIN
	SELECT
		Sta3n,
		App.udf_StationName(Sta3n) AS Station
	FROM (
		SELECT DISTINCT
			Sta3n
		FROM
			App.NVCC_ProductionLog
	) S
	ORDER BY Station
END

